/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.availability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.GuiNPCFactionSelection;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiSelectionListener;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumAvailabilityFaction;
import noppes.npcs.constants.EnumAvailabilityFactionType;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.AvailabilityFactionData;
import noppes.npcs.controllers.data.Faction;

public class SubGuiNpcAvailabilityFaction
extends SubGuiInterface
implements ICustomScrollListener,
GuiSelectionListener {
    protected final Availability availability;
    protected final Map<String, Integer> dataIDs = new HashMap<String, Integer>();
    protected final Map<String, AvailabilityFactionData> dataSets = new HashMap<String, AvailabilityFactionData>();
    protected GuiCustomScroll scroll;
    protected String select = "";

    public SubGuiNpcAvailabilityFaction(Availability availabilityIn) {
        this.setBackground("menubg.png");
        this.xSize = 316;
        this.ySize = 217;
        this.closeOnEsc = true;
        this.availability = availabilityIn;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                if (this.select.isEmpty()) {
                    return;
                }
                int id = this.dataIDs.get(this.select);
                AvailabilityFactionData afd = this.availability.factions.get(id);
                afd.factionAvailable = EnumAvailabilityFactionType.values()[button.getValue()];
                this.availability.factions.put(id, afd);
                this.select = "ID:" + id + " - ";
                Faction faction = FactionController.instance.factions.get(id);
                if (faction == null) {
                    this.select = this.select + "\u00a74" + new TextComponentTranslation("faction.notfound", new Object[0]).func_150254_d();
                } else {
                    String stance = "";
                    switch (afd.factionStance) {
                        case Friendly: {
                            stance = "faction.friendly";
                            break;
                        }
                        case Neutral: {
                            stance = "faction.neutral";
                            break;
                        }
                        case Hostile: {
                            stance = "faction.unfriendly";
                        }
                    }
                    this.select = this.select + faction.getName() + '\u00a7' + "7 (" + '\u00a7' + "3" + new TextComponentTranslation(("availability." + (Object)((Object)afd.factionAvailable)).toLowerCase(), new Object[0]).func_150254_d() + '\u00a7' + "7) (" + '\u00a7' + "9" + new TextComponentTranslation(stance, new Object[0]).func_150254_d() + '\u00a7' + "7)";
                }
                this.func_73866_w_();
                break;
            }
            case 1: {
                GuiNPCFactionSelection gui = new GuiNPCFactionSelection(this.npc, this.getParent(), this.select.isEmpty() ? 0 : this.dataIDs.get(this.select));
                gui.listener = this;
                NoppesUtil.openGUI((EntityPlayer)this.player, gui);
                break;
            }
            case 2: {
                this.availability.factions.remove(this.dataIDs.get(this.select));
                this.select = "";
                this.func_73866_w_();
                break;
            }
            case 3: {
                this.save();
                this.func_73866_w_();
                break;
            }
            case 4: {
                if (this.select.isEmpty()) {
                    return;
                }
                EnumAvailabilityFaction eaf = EnumAvailabilityFaction.values()[button.getValue()];
                int id = this.dataIDs.get(this.select);
                AvailabilityFactionData afd = this.availability.factions.get(id);
                afd.factionStance = eaf;
                this.availability.factions.put(id, afd);
                this.select = "ID:" + id + " - ";
                Faction faction = FactionController.instance.factions.get(id);
                if (faction == null) {
                    this.select = this.select + "\u00a74" + new TextComponentTranslation("faction.notfound", new Object[0]).func_150254_d();
                } else {
                    String stance = "";
                    switch (eaf) {
                        case Friendly: {
                            stance = "faction.friendly";
                            break;
                        }
                        case Neutral: {
                            stance = "faction.neutral";
                            break;
                        }
                        case Hostile: {
                            stance = "faction.unfriendly";
                        }
                    }
                    this.select = this.select + faction.getName() + '\u00a7' + "7 (" + '\u00a7' + "3" + new TextComponentTranslation(("availability." + (Object)((Object)afd.factionAvailable)).toLowerCase(), new Object[0]).func_150254_d() + '\u00a7' + "7) (" + '\u00a7' + "9" + new TextComponentTranslation(stance, new Object[0]).func_150254_d() + '\u00a7' + "7)";
                }
                this.func_73866_w_();
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        super.close();
        ArrayList<Integer> delete = new ArrayList<Integer>();
        for (int id : this.availability.factions.keySet()) {
            if (this.availability.factions.get((Object)Integer.valueOf((int)id)).factionAvailable != EnumAvailabilityFactionType.Always) continue;
            delete.add(id);
        }
        for (int id : delete) {
            this.availability.factions.remove(id);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        GuiNpcLabel label = new GuiNpcLabel(1, "availability.available", this.guiLeft, this.guiTop + 4);
        label.setCenter(this.xSize);
        this.addLabel(label);
        GuiNpcButton button = new GuiNpcButton(66, this.guiLeft + 6, this.guiTop + 192, 70, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 6);
            this.scroll.setSize(this.xSize - 12, this.ySize - 66);
        }
        this.dataIDs.clear();
        this.dataSets.clear();
        for (int id : this.availability.factions.keySet()) {
            String key = "ID:" + id + " - ";
            Faction faction = FactionController.instance.factions.get(id);
            AvailabilityFactionData afd = this.availability.factions.get(id);
            if (faction == null) {
                key = key + "\u00a74" + new TextComponentTranslation("faction.notfound", new Object[0]).func_150254_d();
            } else {
                String stance = "";
                switch (afd.factionStance) {
                    case Friendly: {
                        stance = "faction.friendly";
                        break;
                    }
                    case Neutral: {
                        stance = "faction.neutral";
                        break;
                    }
                    case Hostile: {
                        stance = "faction.unfriendly";
                    }
                }
                key = key + faction.getName() + '\u00a7' + "7 (" + '\u00a7' + "3" + new TextComponentTranslation(("availability." + (Object)((Object)afd.factionAvailable)).toLowerCase(), new Object[0]).func_150254_d() + '\u00a7' + "7) (" + '\u00a7' + "9" + new TextComponentTranslation(stance, new Object[0]).func_150254_d() + '\u00a7' + "7)";
            }
            this.dataIDs.put(key, id);
            this.dataSets.put(key, this.availability.factions.get(id));
        }
        if (!this.select.isEmpty() && !this.dataIDs.containsKey(this.select)) {
            this.select = "";
        }
        this.scroll.setList(new ArrayList<String>(this.dataIDs.keySet()));
        this.scroll.guiLeft = this.guiLeft + 6;
        this.scroll.guiTop = this.guiTop + 14;
        if (!this.select.isEmpty()) {
            this.scroll.setSelected(this.select);
        }
        this.addScroll(this.scroll);
        int p = 0;
        int s = 0;
        if (!this.select.isEmpty()) {
            p = this.dataSets.get((Object)this.select).factionAvailable.ordinal();
            s = this.dataSets.get((Object)this.select).factionStance.ordinal();
        }
        button = new GuiNpcButton(0, this.guiLeft + 6, this.guiTop + this.ySize - 46, 50, 20, new String[]{"availability.always", "availability.is", "availability.isnot"}, p);
        button.setHoverText("availability.hover.enum.type", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(4, this.guiLeft + 58, this.guiTop + this.ySize - 46, 50, 20, new String[]{"faction.friendly", "faction.neutral", "faction.unfriendly"}, s);
        button.setHoverText("availability.hover.faction.type", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, this.guiLeft + 110, this.guiTop + this.ySize - 46, 178, 20, "availability.select");
        button.setHoverText("availability.hover.faction", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.guiLeft + 290, this.guiTop + this.ySize - 46, 20, 20, "X");
        button.setHoverText("availability.hover.remove", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, this.guiLeft + this.xSize - 76, this.guiTop + 192, 70, 20, "availability.more");
        button.setEnabled(!this.select.isEmpty());
        button.setHoverText("availability.hover.more", new Object[0]);
        this.addButton(button);
        this.updateGuiButtons();
    }

    @Override
    public void save() {
        if (this.select.isEmpty()) {
            return;
        }
        EnumAvailabilityFactionType eaft = EnumAvailabilityFactionType.values()[this.getButton(0).getValue()];
        EnumAvailabilityFaction eaf = EnumAvailabilityFaction.values()[this.getButton(4).getValue()];
        AvailabilityFactionData afd = new AvailabilityFactionData(eaft, eaf);
        int id = this.dataIDs.get(this.select);
        if (eaft != EnumAvailabilityFactionType.Always) {
            this.availability.factions.put(id, afd);
            this.dataSets.put(this.select, afd);
        } else {
            this.availability.factions.remove(id);
        }
        this.select = "";
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.select = scroll.getSelected();
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        GuiNPCFactionSelection gui = new GuiNPCFactionSelection(this.npc, this.getParent(), this.dataIDs.get(select));
        gui.listener = this;
        NoppesUtil.openGUI((EntityPlayer)this.player, gui);
    }

    @Override
    public void selected(int id, String name) {
        if (id < 0) {
            return;
        }
        if (!this.select.isEmpty()) {
            this.availability.factions.remove(this.dataIDs.get(this.select));
        }
        Faction faction = FactionController.instance.factions.get(id);
        AvailabilityFactionData afd = new AvailabilityFactionData(EnumAvailabilityFactionType.Is, EnumAvailabilityFaction.Friendly);
        this.select = "ID:" + id + " - ";
        this.select = faction == null ? this.select + "\u00a74" + new TextComponentTranslation("faction.notfound", new Object[0]).func_150254_d() : this.select + faction.getName() + '\u00a7' + "7 (" + '\u00a7' + "3" + new TextComponentTranslation("availability.is", new Object[0]).func_150254_d() + '\u00a7' + "7) (" + '\u00a7' + "9" + new TextComponentTranslation("faction.friendly", new Object[0]).func_150254_d() + '\u00a7' + "7)";
        this.availability.factions.put(id, afd);
        this.func_73866_w_();
        this.updateGuiButtons();
    }

    private void updateGuiButtons() {
        this.getButton(1).setDisplayText("availability.selectquest");
        int p = 0;
        int s = 0;
        Faction faction = null;
        if (!this.select.isEmpty()) {
            faction = FactionController.instance.factions.get(this.dataIDs.get(this.select));
            p = this.dataSets.get((Object)this.select).factionAvailable.ordinal();
            s = this.dataSets.get((Object)this.select).factionStance.ordinal();
        }
        this.getButton(0).setDisplay(p);
        this.getButton(0).setEnabled(!this.select.isEmpty());
        this.getButton(4).setDisplay(s);
        this.getButton(4).setEnabled(!this.select.isEmpty());
        this.getButton(1).setEnabled(p != 0 || this.select.isEmpty());
        this.getButton(1).setDisplayText(faction == null ? "availability.select" : faction.getName());
        this.getButton(2).setEnabled(p != 0);
    }
}

